# -*- coding: cp1252 -*-
#########################################################################################
# Stokastinen simulaatio kiertoliikkeist: SiriusA ja SiriusB kaksoisthti
#  (Dokumentti ss 22-23)
# Taivaanmekaniikan mukaan:
# SiriusA:n sde = 1.7*auringon sde =1.7*696 000 km
# SiriusB on valkoinen kpi, halkaisija vain n. 11700 km
# SiriusA:n massa = 2.1*auringon massa = 2.1*1.9891e30
# SiriusB:n massa = n. auringon massa
# Kiertoaika T=50.1 v
# Thtien vlimatka 19.8 AU, AU = 149 597 870 700 m

# Laske edell olevien tietojen perusteella SiriusA:n ja SiriusB:n
# alkupaikat koordinaatistossa, jossa yhteinen massakeskipiste on origossa
# ja massat x-akselilla
# Arvioi ympyrliikkeen ja kiertoajan perusteella SiriusA:n keskinopeus
# radallaan ja laske sen perusteella SiriusB:n ratanopeus alkutilanteessa.
# Simulaatio ei ole tarkasti reaalimaailman mukainen, mm. koska alkutilanteen
# nopeutena kytetn radan keskinopeutta. Etisyyksisen muutoksista pitisi pysty havaitsemaan
# ellipsin muotoisen ratakyrn syntyminen
##########################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

# grafiikkaikkunan mritys
#scene.range = (3e12,2e5,2e12) #koordinaatiston vaihteluvälit ikkunassa
scene.width = 800 #ikkunan leveys nytll
scene.height = 600 #ikkunan korkeus nytll
scene.forward=vector(0,-0.4,-1)
scene.center=vector(0,0,0)

######### ei muutoksia alla #################################################################
# Alla netist lydetty hydyllinen funktio make_time_string(t),
# joka ilmoittaa parametreina annetun ajan t sopivina aikayksikkin
def make_time_string(t):
    'Accept a number of seconds, return a relative string.'
    #if t < 60: return '%02i seconds'%t
    mins,secs = divmod(t, 60)
    #if mins < 60: return '%02i minutes %02i seconds'%(mins,secs)
    hours, mins = divmod(mins,60)
    #if hours < 24: return '%02i hours %02i minutes'%(hours,mins)
    days,hours = divmod(hours,24)
    if days < 365: return '%03i days %02i hours'%(days,hours)
    years,days = divmod(days,365)
    return '%02i years %03i days'%(years,days)
   
# Alkuarvojen asetus 
radA = 1.7*696000000  # (m) siriusA:n sde = 1.7*auringon sde , radSun=696 000 km
radB = 11700000/2  # (m) siriusB:n sde, on valkoinen kpi, halkaisija 11700 km
massA= 2.1*1.9891e30 # (kg) siriusA:n massa = 2.1*auringon massa, massSun= 1.9891e30
massB= 1.9891e30  # siriusB:n massa= auringon massa
T=50.1*365*24*3600 # kiertoaika
distanceAB=19.8*149597870700 # thtien vlimatka 19.8 AU, AU = 149 597 870 700 m

G=6.67384e-11 # m^3/(kg s^2) Yleinen gravitaatiovakio
const=G*massA*massB #
F=vector(0,0,0)  # Gravitaatiovoima F=const/r^2

######### ei muutoksia yll ##################################################################


# Ohjelmoi oikeat alkupaikat ja nopeudet
xA=-distanceAB/2 
xB=distanceAB/2 
velA=vector(0,0,0)
velB=vector(0,0,0)

# Luodaan thdet (sphere objektit) oikeille paikoilleen sek asetetaan alkutilanteen
# liikemrt ja nopeudet
# Visualisoinnin vuoksi voit suurentaa thtien todellisen koon
# SiruiusB 30-kertaiseksi, SiriusA 1000-kertaiseksi
siriusA=sphere(pos=vector(xA,0,0),radius=30*radA,color=color.yellow,make_trail=True)
siriusB=sphere(pos=vector(xB,0,0),radius=1000*radB,color=color.white,make_trail=True)



#tekstikehys ikkunaan (valmis)
textLabel = label(pos=vector(0, 0.4*distanceAB,0))

def updTextLabel(txtlabel):
    text= text= "Time: {time}".format(time=make_time_string(t))
    text += "\nSiriusA:n etisyys mkp:st: %.0f m" % mag(siriusA.pos)
    text += "\nSiriusB:n etisyys mkp:st: %.0f m" % mag(siriusB.pos)
    txtlabel.text=text

##################################################################################
# simulaatioluuppi
##################################################################################

t=0
dt=2000 # On suuri, jotta kierrosaaika n. 50 v saadaan nopeutettua

finished=True


while finished :
    rate(10000) # 10000, jotta kierrosaaika n. 50 v saadaan nopeutettua
    # 1. Gravitaatiovoiman pivitys
    
    # 2. Thtien liikemrt impulssiperiaatteella
    
   
    # 3. Thtien nopeudet ja paikat 
    

    # tekstikehyksen päivitys
    updTextLabel(textLabel)
    t+=dt


