# -*- coding: cp1252 -*-
##########################################################################
#
# Deterministinen simulaatio: Kierretty ympyrliike
# Aurinko-Maa_Kuu -systeemi  (Dokumentti ss 18-21)
# Alkutilanne: Aurinko origossa, maa x-akselilla ja kuu xy-tasolla
# kierto vastapivn pos. y-akselilta katsotuna
# Kuun ja maan kierrosajat sek kappaleen koot ja orbitaalisteet
# annettu koodissa. Havainnollisuuden vuoksi orbitaalisteet
# ja kappaleiden koot annettu demonstraatioon sopivina
#
#
# Ohjelmoi ensin kuun ja sen ratatason kiertyminen inklinaatiokulman vaikutuksesta
# Sen jlkeen ohjelmoi maan ja kuun liikkeet ratakyrilln
# Extra: Lis maan pyriminen kallistetun akselinsa ympri (tm tulee mys
# tehtvss 10 ohjelmoitavaksi)
###############################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

########### ei muutoksia alla ##################################################
# grafiikkaikkuna

scene.range = 1300
scene.width = 1200 
scene.height = 800 
scene.forward=vector(0,-0.2,-1)
# Alla netist lydetty hydyllinen funktio make_time_string(t), joka ilmoittaa parametreina annetun
# ajan t sopivina aikayksikkin
def make_time_string(t):
    'Accept a number of seconds, return a relative string.'
    if t < 60: return '%02i seconds'%t
    mins,secs = divmod(t, 60)
    if mins < 60: return '%02i minutes %02i seconds'%(mins,secs)
    hours, mins = divmod(mins,60)
    if hours < 24: return '%02i hours %02i minutes'%(hours,mins)
    days,hours = divmod(hours,24)
    return '%02i days %02i hours'%(days,hours)

# Visuaalisesti sovitetut maan ja kuun koot ja etisyydet
rEarth = 30  # 6.38*e6(m) maan sde
rMoon = 8  # 1.74*e6(m) kuun sde
rSun=2*rEarth  # 109*rEart auringon sde
orbRadM=250  # 384.4*e6 (m) kuun kiertoradan säde
orbRadE= 800    # 149.60*e9 (m) maan kiertoradan sde
inc=radians(-5.1454) # 5.1454 deg kuun radan inklinaatiokulma xz-tason suhteen
# Maan ja kuun orbitaalien kierrosajat
TE=365.256363004*24*3600 # 365.256363004 vrk maan kiertoaika -> sek
TM=27.322*24*3600 # 27.322 vrk kuun kiertoaika -> sek


# Maa ja kuu kuvataan suurennettuina palloina 
# maan ja kuun orbitaalit kuvataan ympyrin
origin=vector(0,0,0)
sun=sphere(pos=origin,radius=rSun,color=color.yellow)
earth=sphere(pos=vector(orbRadE,0,0),radius=rEarth,texture=textures.earth) 
earth.rotate(angle=radians(23.4),axis=vector(0,0,-1),origin=earth.pos) # maan kallistus
earthOrbit=ring(pos=sun.pos,axis=vector(0,1,0),radius=orbRadE,thickness=1)
moon=sphere(pos=earth.pos+vector(orbRadM,0,0),radius=rMoon,texture=textures.wood)
moonOrbit=ring(pos=earth.pos,axis=vector(0,1,0),radius=orbRadM,thickness=1)

#tekstikehys ikkunaan
timeLabel = label(pos=sun.pos +vector(0, 4*sun.radius,0))

########### ei muutoksia yll ##################################################



# Ohjelmoi alkutilanne: Kuun aseman kierto ja kuun ratakyrn kallistus
# Huom! Kallista kuun ratakyrobjektin (ring) akselia, joka pysyy vakioasennossa


# Ohjelmoi maan ja kuun kulmanopeudet wE ja wM, joilla saadaan juokseva virtuaaliaika t 
# tsmmn maan ja kuun kierrosaikojen TE ja TM kanssa
#wE=?
#wM=?


##################################################################################
# simulaatioluuppi
##################################################################################

t=0
dt=20   # dt sekunttia merkitsee asteissa (2*pi/T*dt rad)

while (1) :
    # Visuaalista nopeutta voi sdell muuttamalla funktion rate() argumentin arvoa.
    rate(20000)
    # Ohjelmoi maan liike ratakyrlln


    # Ohjelmoi kuun liike ratakyrlln, joka on kallistunut kulman inc verran akselin z ympri



    text= "Aika: {0}".format(make_time_string(t))
    timeLabel.text=text
    t+=dt


