# -*- coding: cp1252 -*-
######################################################################
#
# Deterministinen simulaatio ympyrliikkeiden yhdistminen:
# (Dokumentti ss 16-17
# Ohjelmoi kehpisteiden "vierimisliike" pitkin ulomman ympyrn siskeh
# Kaikki liike tapahtuu xy-tasossa (z=0)
# Vierivn ympyrn keskipisteen etisyytt r1 sdetn likukoskettimella R1slider ja
# vierivn ympyrn kehpisteiden sdett r2 sdetn likukoskettimella R2slider
# Vieriminen aloitetaan painikkeella shotButton.
# Aina, kun Widget -elementtej ksitelln, suoritetaan funktio setStart(), joka
# pivitt alkutilanteen (t=0) kehpisteille ja isolle ympyrlle valituilla ympyrn steill
# 
#####################################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *


# grafiikkaikkuna
scene.range = 100
scene.width = 1000
scene.height = 800

################### widget elementit ja niiden tapahtumanohjausfunktiot ################################

# Funktio setStart() pivitt alkutilanteen (t=0) kehpisteille ja isolle ympyrlle
# valituilla steill r1 ja r2
def setStart():
    global P,P0,circle,tracer,t,move,r1,r2,T1,T2,dalpha
    move=False
    t=0
    # Ohjelmoi funktio, joka pivitt alkutilanteen (t=0) kehpisteille ja isolle ympyrlle

# widget- tapahtumanksittelijfunktiot

# setR1(evt) st vierivn ympyrn keskipisteen kiertosdett, ei tarvitse muuttaa
def setR1(evt):
    setStart()

# setR2(evt) st vierivn ympyrn kehpisteiden kiertosdett, ei tarvitse muuttaa
def setR2(evt):
    setStart()

# shot() aloittaa vierimisliikkeen, ei tarvitse muuttaa
def shot(evt):
    global move
    setStart()
    move=True   

# widget-elementit + ohjaustekstit        
wtext(pos=scene.caption_anchor,text='sd ison ympyrn sdett (30-60) ')
R1slider=slider(pos=scene.caption_anchor,bind=setR1,min=30,max=60,step=1,bottom=10,top=10,length=100)
wtext(pos=scene.caption_anchor,text='sd vierivn ympyrn sdett (10-45) ')
R2slider=slider(pos=scene.caption_anchor,bind=setR2,min=10,max=45,step=1,bottom=10,top=10,length=100)
shotButton=button(pos=scene.caption_anchor,bind=shot,text='<h3>Liikkeelle</h3>',color=color.blue)


################### widget elementit ##########################################################


# Alkuarvot muuttujille
r1 = 60  # ulomman ympyrn sde
r2 = 30   # vierivn ympyrn sde

n=5 #pisteiden lkm

# Iso ympyr xy-tasolla. Siskehll vieriv ympyr
kp1=vector(0,0,0) # ison ympyrn kp
circle=ring(pos=kp1,axis=vector(0,0,1), radius=r1+r2+1, thickness=1,color=color.blue)

# Kehpisteiden rakentaminen:
# Luodaan ensin staattiset kehpisteiden koordinaatit listaan P0, jonka jlkeen
# pisteet saadaan nytlle points-objektilla P=points(pos=P0)

P0=[0 for i in range(n)]
dalpha=radians(360/n) # Kehpisteiden vlisen keskuskulman suuruus
for i in range(0,n):
    alpha=pi/2+i*dalpha
    P0[i]=kp1+vector(0,r1,0)+r2*vector(cos(alpha),sin(alpha),0)    
P=points(pos=P0,color=color.red,radius=5)

# Yhden kehpisteen jlki
tracer=sphere(pos=P0[0],radius=0.5,color=color.white,make_trail=True,retain=50)

# Ohjelmoi funktiot kp(t), joka palauttaa vierivn ympyrn keskipisteen paikan ajan t funktiona
# sek funktio r(t), joka siirt vierivn ympyrn kehpisteiden P paikkoja ajan t funktiona
# Huom! points -objektin P pisteiden paikanmuutos onnistuu esimerkiksi poistamalla entiset ja
# laskemalla uudet paikat (P0) sek lismll ne objektiin points
#       P.clear()
#       P.append(P0)
# Kiertoaika T1 on keskipisteen kp kiertoaika ja T2 kehpisteiden kiertoaika.
# Ratkaise, miten T2 riippuu T1:st

T1=10 #keskipisteen kiertoaika T1 vakioarvo

# Ohjelmoi funktiot kp(t) ja r(t), joka kutsuu funktiota kp(t)

def kp(t):
    global kp1,T1,r1
    r1=R1slider.value

def rt(t):
    global T2,r2,dalpha,P0,P
    r2=R2slider.value


#tekstikehys ikkunaan ja sen pivitysfunktio
textLabel = label(pos=vector(70,60,0))
def updTextLabel(txtlabel):
    text= "\nkp:n sde: %.1f " % R1slider.value
    text += "\nkp:n kierrosaika: %.1f " % T1
    text += "\nVierivn ympyrn sde: %.1f" % R2slider.value
#    text += "\nVierivn ympyrn kierrosaika: %.1f" %  T2
    txtlabel.text=text


t=0
dt=0.01
move=False

# Pluuppi, ei tarvitse muuttaa
while(1):
    rate(100)
    if move==True:       
        rt(t)    
        t+=dt
    updTextLabel(textLabel)

    

