# -*- coding: cp1252 -*-
#############################################################
# Deterministinen simulaatio, ympyrliike
# (Dokumentti ss 16-17)
# Tehtvn ohjelmoida Helium-atomin elektronien liike ympyrliikkeell
# ympyrliikkeet alkavat niilt paikoilta, joissa elektronit sijaitsevat alussa
# Ympyrliikkeiden ratatasot ovat kohtisuorassa toisiaan vastaan.
# sd elektronin nopeus visuaalisesti sopivaksi
############################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *


scene.range = 40 
scene.width = 800 
scene.height = 600
scene.forward=vector(-0.3,0,-1)

############ ei muutoksia #####################################
#Helium-atomin ydin, muodostetaan useista objekteista yksi compound -objekti
He=compound(
[sphere(pos=vector(-0.3,0.8,0),radius=1,color=color.red),
sphere(pos=vector(0.7,-0.8,0),radius=1,color=color.red),
sphere(pos=vector(-0.3,-0.8,0),radius=1,color=color.green),
sphere(pos=vector(0.7,0.8,0),radius=1,color=color.green)])
He.pos=vector(0,0,0)

# elektroniT ja niiden orbitaalisteet
orbRadius=20
# 1. elektroni pisteess (20,0,0) positiivisella x-akselilla, kierto xy-tasolla
e1=sphere(pos=He.pos+vector(orbRadius,0,0),radius=0.7,color=color.cyan,make_trail=True,
              interval=1, retain=100) # mrmittainen jlki
# 2. elektroni pisteess (0,20,0) positiivisella y-akselilla, kierto xz-tasolla
e2=sphere(pos=He.pos+vector(0,orbRadius,0),radius=0.7,color=color.cyan,make_trail=True,
              interval=1, retain=100) # mrmittainen jlki


############ ei muutoksia #####################################


#######   Ohjelmoi Helium-atomi ###########################

t=0
dt=0.01

while (1):
    rate(100)
    a=2 # elektronin kiertonopeuden kerroin
 
    t+=dt
    
