# -*- coding: cp1252 -*-
##########################################################################################
# Dynamiikan stokastinen simulaatio,
# Ilmanvastuksellinen heittollike ja Widget-elementtien kytt simulaatiossa
# (Dokumentti ss 11-15)
#  1. Ohjelmoi pallon liike ilmanvastus huomioiden
#     Huom! pallon liike tapahtuu xy-tasossa, joten 2D- tarkastelu riitt. 
#     3D koordinaatistossa xy-tasossa fii=pi/2, jolloin  sin(pi/2)=1 ja cos(pi/2) = 0 
#     Alkuarvoja muutetaan widget-ikkunasta, jossa valmiina alkunopeuden ja nousukulman
#     liukustimet (slider) sek heiton aloituspainike (button)
#     Alkutilanne: pallon sde 0.1 m, massa = 0.1 kg
#     Ilmanvastuksen laskenta: C=0.5 ja rho(ilma)=1.29 kg/m^3
#
#  2. Lis liukustimet
#     massalle vlille 50 g - 1500 g (huom! gravitaatiovoima muuttuu) sek
#     pallon steelle 4 cm - 20 cm
#     sek ohjelmoi stjen vaikutus pallon liikerataan
#
##########################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

# wxPython/ widget -ikkunamoduuli
#import wx


scene.width = 800 
scene.height = 600 
scene.title='Ilmanvastuksellinen heittoliike'

############# Ei muutoksia ##############################################
start=vector(-30,-20,0) #alkupaikka
curve(pos=[start,start+vector(70,0,0)]) #pohjatason viiva
############# Ei muutoksia ##############################################


####### widget -elementtien mrittely alku #########################################


def setStart():
    global start,ball
    ball.pos=start #  Globaalin muuttujan arvon asetus
    ball.acceleration=vector(0,0,0)
    ball.velocity=vector(0,0,0)

# widget-elementtien tapahtuman (evt) ksittelyfunktiot

# setAngle(evt) muuttaa slider1:n mukaisesti nousukulmaa
def setAngle(evt):
    setStart()
# setSpeed(evt) muuttaa slider2:n mukaisesti lahtonopeutta
def setSpeed(evt):
    setStart()

    
# shot() ampuu pallon liikkeelle painikkeesta shotButton ja asettaa heiton alkuarvot
def shot(evt):
    global Fgravitation, ball
    setStart()
    Fgravitation=ball.mass*vector(0,-9.81,0)
    angle0=radians(slider1.value) # huom! paik. muutt.
    v0mag=slider2.value # huom! paik. muutt.
    vy=v0mag*sin(angle0) # huom! paik. muutt.
    vx=v0mag*cos(angle0) # huom! paik. muutt.
    ball.velocity=vector(vx,vy,0)
    ball.acceleration=vector(0,-9.8,0)  #Asetetaan vetovoima plle 
       
# tekstit, liukustimet ja painike asettuvat web-sivun alareunaan (caption)
# jrjestyksess vasemmalta oikealle
wtext(pos=scene.caption_anchor,text='Aseta lhtkulma (0-90)asteissa')
slider1=slider(pos=scene.caption_anchor,bind=setAngle,min=0,max=90,step=1,bottom=10,top=10,length=100)
wtext(pos=scene.caption_anchor,text='Aseta lhtnopeus (5-35)m/s')
slider2=slider(pos=scene.caption_anchor,bind=setSpeed,min=5,max=35,step=1,bottom=10,top=10,length=100)
shotButton=button(pos=scene.caption_anchor,bind=shot,text='<h3>Laukaise</h3>',color=color.blue)

########  widget -elementtien mrittely loppu   #############################################



#tekstikehys ikkunaan ja sen pivitysfunktio
textLabel = label(pos=vector(0,20,0))
def updTextLabel(txtlabel):
    text= "\nNousukulma: %.0f astetta" % slider1.value
    text += "\nLahtonopeus: %.1f m/s" % slider2.value
    text += "\nVaakasuuntainen pituus: %.1f m" % (ball.pos.x-start.x)
    txtlabel.text=text

# Vino heittoliike pisteest start.
# Alkunopeus ja heittokulma mrtn liukustimill (slider).
# Pallon liikkeelle lht tapahtuu painikkeesta Laukaise (button)
ball=sphere(pos=start,color=color.magenta,make_trail=True) #Heitettv pallo
ball.radius=0.05 #Pallon sde 5 cm
ball.mass=0.3 # Pallon massa 300 g
ball.velocity=vector(0,0,0) # Nopeus
ball.acceleration=vector(0,0,0)# Kiihtyvyys
Fgravitation=vector(0,0,0) # Maan vetovoima
FairResistance=vector(0,0,0) # Ilmanvastus

# Asetetaan likustimille lhtarvot
slider1.value=45 # nousukulma asteissa = radians(45) rad
slider2.value=15 # lhtnopeus 15 m/s

# aika ja aika-askel
t=0
dt=0.01

while True:
    rate(100) #viive (reaaliaika: n. 1/dt)
    t+=dt 

    # Ohjelmoi pallon dynamiikka thn ja huomioi widget elementtien tapahtumien
    # pivitysfunktiot setAngle(evt), setSpeed(evt) ja shot(evt)
    


    # tekstikehyksen pivitys
    updTextLabel(textLabel)
        

           
