# -*- coding: cp1252 -*-
#########################################################################
# Dynamiikan stokastinen simulointiharjoitus (Dokumentti ss 8-10)
# Kitka: Ohjelmoi kitkan vaikutus liikkeeseen
# 
# Lhttiedot:
#   Kappaleiden massa 1.5 kg
#   Kappaleiden alkunopeuden suuruus 15 m/s
#   Pinnan ja kappaleiden vlinen kitkakerroin u=0.35
#
#   Staattiset alkuarvot
#   Laatikko 1: kulkulinja AB, laatikko 2: kulkulinja CD
#   Pisteet A=(-30,20,0),B=(50,20,0), C=(-30,0,0) ja D=(50,-10,0)
#   Maan pinnan taso on xz-tason suuntainen 
#   Huom! vakiokiihtyvyyksiksi tulee saada:
#   Laatikko 1 a1=(-2.9,0,0) ja laatikko 2 a2=(-1.7,0.2,0)
##########################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

####### Ei muutoksia ###########################################################
# grafiikkaikkunan mritys
scene.title="Kitka"
scene.range=50 
scene.width = 800 #ikkunan leveys 
scene.height = 600 #ikkunan korkeus
scene.forward=vector(0,-0.3,-1)
scene.center=vector(0,20,0)
textLabel=label(pos=vector(-10,40,0))


# Kulkulinjojen alku- ja ptepisteet
A=vector(-30,20,0);B=vector(50,20,0)
C=vector(-30,0,0);D=vector(50,-10,0)

#Tasot 
H=vector(0,1,0)
plane1Length=mag(B-A)
plane2Length=mag(D-C)
# vaakasuora taso
plane1=box(pos=vector(A.x+plane1Length/2,A.y-1,A.z),axis=B-A,height=1,width=10,length=plane1Length)
# kalteva taso
alpha=diff_angle(D-C,vector(1,0,0)) # Tason 2 kaltevuuskulma
plane2=box(pos=vector(C.x+0.5*plane2Length*cos(alpha),C.y-0.5*plane2Length*sin(alpha)-1,C.z),axis=D-C,height=1,width=10,length=plane2Length)

#  laatikoiden lhtarvot
mass=1.5  # kg
friction=0.3  # dimensioton
speed0=15  # m/s

# Laatikko 1 Vaakasuoralla tasolla 1   
box1=box(pos=A,length=4, height=2, width=4,color=color.cyan)
box1.velocity=vector(0,0,0)
box1.mass=mass
box1.acceleration=vector(0,0,0)

# Laatikko 2 Kaltevalla tasolla 
box2=box(pos=C,length=4, height=2, width=4,color=color.cyan)
box2.mass=mass
box2.rotate(angle=-alpha,axis=vector(0,0,1)) 
box2.velocity=vector(0,0,0) 
box2.acceleration=vector(0,0,0)
####### Ei muutoksia ###########################################################


# Ohjelmoi vakiona pysyvt kitkavoimat sek nopeuksien ja kiihtyvyyksien alkuarvot
# Huom! Kyt pisteit A, B, C ja D hyvksi nopeusvektoreiden suuntia mritettess




t=0
dt=0.01

while 1 :
    rate(100)
    # Ohjelmoi molempien laatikoiden dynamiikka thn



    # Tekstikehyksen tulostus, ei tarvitse tehd muutoksia
    text='laatikko 1: kiihtyvyys  (%.1f,%.1f,%.1f)' % (box1.acceleration.x,box1.acceleration.y,box1.acceleration.z)
    text += '\nlaatikko 1: nopeus (%.1f,%.1f,%.1f)' % (box1.velocity.x,box1.velocity.y,box1.velocity.z)
    text += '\nlaatikko 2: kiihtyvyys (%.1f,%.1f,%.1f)' % (box2.acceleration.x,box2.acceleration.y,box2.acceleration.z)
    text += '\nlaatikko 2: nopeus (%.1f,%.1f,%.1f)' % (box2.velocity.x,box2.velocity.y,box2.velocity.z)
    textLabel.text=text
           
    t+=dt



