
# -*- coding: cp1252 -*-
###########################################################################
# Esimerkki 2 heittoliike (Dokumentti ss 5-7)
#
#    Ohjelmoi stokastinen simulaatio 3D heittoliikkeelle zx-tasossa. 
#    Alkupiste sijaitsee origossa, heiton nousukulma alpha0 ja kiertokulma fii
#    sek alkunopeuden itseisarvo v0 annetaan alkuarvoina koodissa.
#    Tehtvn on valmiiksi ohjelmoitu pisteiden kerys, jota ei tarvitse muuttaa.
#    Tehtvnsi on saada 20 pistett, mik onnistuu, jos lydt sellaiset
#    alkuarvoasetukset, ett pallo menee molempien silmukoiden lpi riittvn
#    lhelt keskustaa.
#############################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

######### Ei muutoksia #########################################################
# grafiikkaikkunan mrityksi
scene.width = 800 #ikkunan leveys pikseleiss nytll
scene.height = 600 #ikkunan korkeus pikseleiss nytll
scene.resizable =True # ikkunan kokoa voidaan muuttaa
scene.title = "Tasainen ja tasaisesti kiihtyv 3D liike"
scene.forward=vector(0.1,-0.3,-1)# kameran suuntaus

#Koordinaatisto 
arrow(pos=vector(0,0,0), length=40,axis=vector(1,0,0), shaftwidth=0.3,color=color.blue)
arrow(pos=vector(0,0,0), length=40,axis=vector(0,1,0), shaftwidth=0.3,color=color.red)
arrow(pos=vector(0,0,0), length=40,axis=vector(0,0,1), shaftwidth=0.3,color=color.green)

#Reunaympyrviivan piirto

cpoints=[vector(60*cos(radians(deg)),0,60*sin(radians(deg))) for deg in arange(0,360,1)]
curve(pos=cpoints)
#renkulat
ring1=ring(pos=vector(-27.2,42,13.9),axis=vector(-0.3,0,0.14),
           radius=2.5, thickness=0.5,color=color.yellow)
ring2=ring(pos=vector(-54.4,0,25.4),axis=vector(0,1,0),
           radius=2.5, thickness=0.5,color=color.yellow)
#pisteiden tekstikehys ja apumuuttujat sek funktio, joka laskee pistetilanteen
pointsLabel=label(pos=vector(-20,50,30))
pointsLabel.text='Pisteet: 0'
points=0
#apumuuttujat
p1=True
p2=True

def testPoints():
    global p1,p2,points
    # 10 pistett, jos menee riittvn lhelta rinkulan keskustaa
    # p1=False est pisteiden kertautumisen ohituksen aikana
    if mag(ball.pos-ring1.pos)<2*ball.radius and p1==True:
        points+=10
        p1=False
    if mag(ball.pos-ring2.pos)<2*ball.radius and p2==True:
        points+=10
        p2=False
        
########## Ei muutoksia ######################################################

# Pallo ja sen attribuutit
ball=sphere(pos=vector(0,0,0),radius=1,color=color.magenta,make_trail=True)
ball.velocity=vector(0,0,0)
# Vakiot ja alkuarvot sek alkunopeuden vektoriesityksen mritys
g=vector(0,-9.81,0)

# Poista kommenteista ja anna sopivat lhtarvot

#v0=? # Anna sopiva lhtnopeus (m/s)
#alpha0=radians(?) # Anna sopiva nousukulma asteissa
#fii=radians(?)  # Anna sopiva suuntakulma asteissa

# Mrittele alkunopeuden komponentit ja alkunopeus
#v0x=?
#v0z=?
#v0y=?
#ball.velocity=?


# aika-askel ja simulaation toistoluuppi
t=0
dt=0.01

while (1) :
    rate(100)

    if ball.pos.y >= 0:
        #testataan pistetilanne ja tulostetaan tekstikehykseen (Ei tarvitse muuttaa)
        testPoints()
        text='Pisteet: %i '% points
        pointsLabel.text=text

        # pallon kinematiikka thn
        ball.velocity += g*dt
        ball.pos+= ball.velocity*dt + 0.5*g*dt**2
           
    t+=dt



