# -*- coding: cp1252 -*-
###############################################################################
##Esimerkki 1 deterministinen simulaatio (Dokumentti ss 3-5)
##1. Lis pallo 3, joka lhtee pisteest D=(-30,40,0) ja liikkuu tasaisesti kiihtyvll
##   3 m/s^2 liikkeell alkunopeudella 3 m/s linjan DC suuntaisesti
##
##2. Lis pallo 4, joka lhtee pisteest E=(-30,50,0) ja alkunopeudella 20 m/s vaakatasoon
##   eli x-akselin suuntaan ja liikkuu tasaisesti kiihtyen kunnes kohtaa xz-tason
##   Vakiokiihtyvyys on maan vetovoiman kiihtyvyys 9.81 m/s^2 suoraan alaspin.
##   Laita jlkimmiselle pallolle, joka on heittoliikkeess, jlki plle
##############################################################################
from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *


# grafiikkaikkunan mrityksi
scene.width = 800 #ikkunan leveys pikseleiss nytll
scene.height = 600 #ikkunan korkeus pikseleiss nytll
scene.resizable =True # ikkunan kokoa voidaan muuttaa
scene.title = "Tasainen ja kiihtyv suoraviivainen liike"
scene.forward=vector(-0.1,-0.1,-0.6)# kameran suuntaus


#Koordinaatisto ikkunaan
xax=arrow(pos=vector(0,0,0), length=30,axis=vector(1,0,0), shaftwidth=0.3,color=color.blue)
yax=arrow(pos=vector(0,0,0), length=30,axis=vector(0,1,0), shaftwidth=0.3,color=color.red)
zax=arrow(pos=vector(0,0,0), length=30,axis=vector(0,0,1), shaftwidth=0.3,color=color.green)

# Liikkeiden alku- ja ptepisteet
A=vector(-30,20,0)
B=vector(-30,-20,0)
C=vector(0,0,0)

# Yksikkvektorit A:sta C:hen ja B:st C:hen
s10=norm(C-A)
s20=norm(C-B)

# Pallot ja niiden alkuarvojen alustus
ball1=sphere(pos=vector(-30,20,0),radius=1,color=color.red)
velocity1=5*s10
ball2=sphere(pos=vector(-30,-20,0),radius=1,color=color.blue)
initVelocity2=2*s20
acceleration2=1.5*s20

# Simulaatioaskel ja -luuppi
t=0
dt=0.01

while (1):
    rate(100) # simulaation tajuus
    if ball1.pos.x < C.x : # pyshtymisehto
        ball1.pos = A + velocity1*t
    if ball2.pos.x < C.x : # pyshtymisehto
        ball2.pos = B + initVelocity2*t +0.5*acceleration2*t**2
    t+=dt



