# -*- coding: cp1252 -*-
#########################################################################
# Stoakstinen simulaatio: Kitkallinen pallomaisten kappaleiden (pinnan) trmykset
# (dokumentti ss 34 - 41)
# Ohjelma simuloi curling pelin viimeisen kiven heittoa.
#   Vihret ovat johtotilanteessa 2-0 ja oikealla heitolla tilanne sadan kntymn
#   violeteille 0-2
#
# Ohjelmoi widget-ikkunan tapahtumanksittelijfunktiot, liikkeen ja trmyksien
# hallinnan funktiot, sek tydenn pluuppiin trmysten ksittelijfunktion kutsu
# Huom! Kivien trmyksess huomioitava pyrimisliikkeen vaikutus kitkan vlityksell
# sek etenevn liikkeeseen ett pyrimisliikkeeseen.
#########################################################################


from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *


############# ei muutoksia alla ###############################################################

scene.range = 70 
scene.width = 1100 
scene.height = 700
scene.forward=vector(0,-0.5,0)
scene.center=vector(30,0,0)


# Sttekijt
fslid = 0.09; # liukumiskitkakerroi 
graniteFriction = 0.02 # graniittikiven kitkakerroin (trmyksiss)
frot=0.006 # pyrimiskitkakerroin
e=.9 # sysyskerroin
dvThreshold=0.001 # nopeuden  muutoskynnys, jonka jlkeen nopeus asetetaan 0:ksi
dwThreshold=0.0001 # kulmanopeuden muutoskynnys, jonka jlkeen kulmanopeus asetetaan 0:ksi

# Peliobjekteina curling-kivet
mass = 19.5 # massa kg
R = 0.15;r = 0.06 # (m) Kiven (trmys)sde sek pohjassa olevan kitkarenkaan todelliset amitat 
rockRad=2.5  # kiven steen arvo nytll = trmyksen rajasde 
rockHeight=2 # kiven korkeus nytll

# Voidaan laskea vakioarvoina
g = 9.81 # maan vetovoiman kiihtyvyyden suuruus
I=0.5 * mass * R * R # kiven hitausmomentti 
alphaMag=frot*mass*g*r/I # kulmakiihtyvyyden suuruus (pyrimiskitkan aiheuttama)
aMag = fslid * g # kiihtyvyyden suuruus a=f*g (etenemiskitkan aiheuttama)  
fii=pi/2 # alkunopeuden suunta xz-tasossa (oletus x-akseli, sdetn widget-ikkunasta)

# Kentt
sheetWidth=60 # kentn leveys
sheetLength=80 # kentn pituus
curlingSheet = box(pos=vector(0,-1,0),length=2*sheetLength,height=2,width=sheetWidth,color= vector(0,1,1))
lamp = local_light(pos=vector(40,50,0),color=color.white)
# kentn renkaat ja viivat
xkp=37
extrusion(path=[vector(xkp,0,0),vector(xkp,1,0)],shape=shapes.circle(radius=7.1,thickness=3),color=color.red)
extrusion(path=[vector(xkp,0,0),vector(xkp,1,0)],shape=shapes.circle(radius=4.5,thickness=3),color=color.white)
extrusion(path=[vector(xkp,0,0),vector(xkp,1,0)],shape=shapes.circle(radius=2),color=color.white)
startP=vector(-50,2,0)


# heittokiven (startP) ja muiden kivien alkuasemat
pos1=[startP,vector(44.64,2,8.96)]
pos2=[vector(37.28,2,-6.08),vector(31.6,2,5.84),vector(24.4,2,-2.48)]
# kivien ja kahvojen tallennusrakenteet (listat). Kivien avulla hoidetaan etenevn liikkeen 
# ja kahvojen avulla pyrimisliikkeen visualisointi, kivien kyttytyminen lasketaan
# todellisten curling-kivien ominaisuuksien mukan
rocks=[0 for i in range(5)]
handles=[0 for i in range(5)]
rockInStart=True # sdt widget-ikkunassa mahdollisia vain, jos on alkutilanne

# heittokiven suunnan thtmiseen tarkoitettu vektori-objekti
dirArrow=arrow(pos=startP,axis=vector(sin(fii),0,cos(fii)),length=35,color=color.black,shaftwidth =0.5)

# Kivien luonti
def createRocks():
  global rocks,pos1,pos2,rockHeight,rockRad
  for i in range(len(pos1)):
    #print('pos1[%i]=%s ')% (i,pos1[i])
    rocks[i]=cylinder(pos=pos1[i], axis=vector(0,rockHeight,0), radius=rockRad,color=color.orange)
    handles[i]=ring(pos=pos1[i]+vector(0,rockHeight,0),axis=vector(1,0,1),
                    radius=0.7*rockRad,thickness=0.4,color=color.white)
    rocks[i].v=vector(0,0,0)  # etenemisnopeus
    handles[i].w=vector(0,0,0)  # kulmanopeus  
    
  for j in range(len(pos2)):
    rocks[2+j]=cylinder(pos=pos2[j], axis=vector(0,rockHeight,0), radius=rockRad,color=color.green)
    handles[2+j]=ring(pos=pos2[j]+vector(0,rockHeight,0),axis=vector(1,0,-1),
                      radius=0.7*rockRad,thickness=0.4,color=color.white)
    rocks[2+j].v=vector(0,0,0) # etenemisnopeus
    handles[2+j].w=vector(0,0,0)  # kulmanopeus
  handles[0].axis=vector(0,0,-1)

createRocks()

# Alkuasetelman asetus heiton uusintaa varten
def setStart():
  global rocks,handles,pos1,pos2,rockHeight
  for i in range(len(pos1)):
    rocks[i].pos=pos1[i]
    handles[i].pos=rocks[i].pos+vector(0,rockHeight,0)
    rocks[i].v=vector(0,0,0)  
    handles[i].w=vector(0,0,0)  
   
  for j in range(len(pos2)):
    rocks[2+j].pos=pos2[j]
    handles[2+j].pos=rocks[2+j].pos+vector(0,rockHeight,0)
    rocks[2+j].v=vector(0,0,0)
    handles[2+j].w=vector(0,0,0)
  handles[0].axis=vector(0,0,-1)

############# ei muutoksia yll ###############################################################

######### Liikkeen ja trmysten hallinta ################################################

# colliders taulukkoon kirjatan yls trmystilanteessa olevat objektiparit
# alustus arvoilla False   (taulukosta tarvitaan vain ylkolmion alkiot)
colliders=[[False for j in range(len(rocks))] for i in range(len(rocks))] 

        

################ widget elementit ja niiden tapahtuman ksittelyfunktiot ##################

# Ohjelmoi tapahtumanksittelijfunktiot. Muista global mre pohjelman muuttujille
def setAngularSpeed (evt): 
  global initAngularSpeed 
  

def setSpeed(evt):
  global initSpeed
  
  
def setDirection(evt):
  global fii,dirArrow,handles,startP,rockInStart
  
      
def start(evt):
  global rockInStart
  
    
def shot(evt):
  global rocks,handles,speedAngle,initSpeed,initAngularSpeed,rockInStart,alphaMag, alpha
  
  

wtext(pos=scene.caption_anchor,text='Kiven suuntaus (-0.1 - 0.1) rad ')
directionSlider=slider(pos=scene.caption_anchor, bind=setDirection, min=-0.1, max=0.1,step=0.001,bottom=10,top=10,length=200)
directionSlider.value=0
wtext(pos=scene.caption_anchor,text='Lhtnopeus (5-30)m/s ')
speedSlider=slider(pos=scene.caption_anchor, bind=setSpeed, min=5, max=30,step=0.1,bottom=10,top=10,length=100)
speedSlider.value=15
wtext(pos=scene.caption_anchor,text='Alkukulmanopeus (-2.0 - 2.0) rad/s ')
angularSpeedSlider= slider(pos=scene.caption_anchor, bind=setAngularSpeed, min=-2, max=2,step=0.1,bottom=10,top=10,length=100)
angularSpeedSlider.value=0
shotButton=button(pos=scene.caption_anchor,bind=shot,text='<h3>Liukuun</h3>',color=color.blue)

startButton = button(pos=scene.caption_anchor,bind=start,text='<h3>Alkutilanne</h3>',color=color.blue)


############# widget elementit ja niiden tapahtuman ksittelyfunktiot ####################


##########################################################################################
#Liikkeen ja trmyksien hallinnan funktiot

# applySliding() ksittelee vapaan liukumisen
def applySliding():
  # body
  i=0 # vain, jotta ohjelma toimii alkutilanteessa
      

# checkForCollision() tarkistaa ja kirjaa yls globaaliin taulukkoon kaikki mahdolliset trmvt kiviparit    
def checkForCollision():
  # body
  i=0 # vain, jotta ohjelma toimii alkutilanteessa
                
# applyCollision(roc1,handle1,rock2,handle2) ksittelee trmykset          
def applyCollision(rock1,handle1,rock2,handle2):
  # body
  i=0 # vain, jotta ohjelma toimii alkutilanteessa
    
##########################################################################################


#######   Simulaation pluuppi ###########################

t=0
dt=0.01

while (1):
  rate(100)
  
  applySliding()

  checkForCollision()
  # Ohjelmoi trmysten ksittelijfunktion kutsu

  t+=dt
    

