# -*- coding: cp1252 -*-
##################################################################################
#
# Stokastinen simulaatio: Kitkaton pallomaisten kappaleiden trmys (dokumentti ss 33 - 40)
# Ohjelma simuloi kaasumolekyylien liikett ei koordinaattiakseleiden suuntaisten
# tasojen rajaamassa tilassa. Molekyylit kulkevat suoraviivaisesti ja trmvt
# tysin kimmoisasti satunnaisesti ns. Brownin liikkeen mukaisesti
#  
# Ohjelmoi funktioiden
#   applyFlying()
#   checkForCollision()
#   handleCollision()
# toiminta sek tydenn simulaation toistoluuppi
#
##################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

from random import randint
from random import random

############# ei muutoksia alla #####################################################
scene.width = 800 
scene.height = 600 

# seinien koko ja paksuus
side = 2.1
thick = 0.04 # seinn paksuus ohut, jolloin sit ei huomioida en trmysten ksittelyss
s2 = 2*side

# Graafinen kuutio, jonka keskus origossa
# Laatikko luodaan koordinaattiakseleiden suuntaisesti, mutta sen asentoa
# knnetn simulaatiossa 3-ulotteisesti

# oikea sein
wallR = box (pos=vector( side,0,0),axis=vector(-1,0,0), width=s2,length=thick,height=s2,
             opacity=0.3, color = color.yellow) 
# vasen sein
wallL = box (pos=vector(-side, 0, 0), axis=vector(1,0,0),width=s2,length=thick,height=s2,
             opacity=0.3,  color = color.yellow)
# pohja
wallB = box (pos=vector(0, -side, 0),up=vector(0,1,0), width=s2,length=s2,height=thick,
             opacity=0.3, color = color.yellow)
# kansi
wallT = box (pos=vector(0,  side, 0), up=vector(0,-1,0),width=s2,length=s2,height=thick,
             opacity=0.3, color = color.yellow)
# takasein
wallBK = box(pos=vector(0, 0, -side),up=vector(0,0,1), width=s2,length=s2,height=thick,
             opacity=0.3,color = color.yellow)
# etusein, joka asetetaan lopuksi nkymttmksi
wallF = box(pos=vector(0, 0, side),up=vector(0,0,-1), width=s2,length=s2,height=thick,
            opacity=0.0, color=vector(0.7,0.7,0.7))

# kiertokulma, kiertoakseli ja laatikon kallistus
rotAngle=0.3
rotAxis=vector(1,1,1)
wallB.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallL.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallT.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallR.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallBK.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallF.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallF.visible=False

# trmyksiss matemaattisesti ksiteltvien tasojen <n,d> konstruointi ja tallennus listaan planes[]
# Huom! tasot tulostetaan komentotulkkiin. Kaikki d-arvot negatiivisia,
# koska normaalit osoittavat kaikki origoa kohti
planes=[]

# pohjasein
nB=vector(0,1,0)
nB=rotate(nB,rotAngle,rotAxis)
dB=dot(wallB.pos,nB)
planes.append([nB,dB])

# vasen sein
nL=vector(1,0,0)
nL=rotate(nL,rotAngle,rotAxis)
dL=dot(wallL.pos,nL)
planes.append([nL,dL])

# kansi 
nT=vector(0,-1,0)
nT=rotate(nT,rotAngle,rotAxis)
dT=dot(wallT.pos,nT)
planes.append([nT,dT])

# oikea sein 
nR=vector(-1,0,0)
nR=rotate(nR,rotAngle,rotAxis)
dR=dot(wallR.pos,nR)
planes.append([nR,dR])

# takasein 
nBK=vector(0,0,1)
nBK=rotate(nBK,rotAngle,rotAxis)
dBK=dot(wallBK.pos,nBK)
planes.append([nBK,dBK])

# etusein 
nF=vector(0,0,-1)
nF=rotate(nF,rotAngle,rotAxis)
dF=dot(wallF.pos,nF)
planes.append([nF,dF])

planeNmb=len(planes)

# tasojen tulostus komentotulkkiin
for i in range(planeNmb):
  print("n=",planes[i][0],", d=",planes[i][1])

#Pohjatason (xz-suuntainen taso) ja scenen asetukset
cornerDown=rotate(vector(-side,-side,side),rotAngle,rotAxis)
box(pos=cornerDown,up=vector(0,1,0),width=s2,length=2*s2,height=0.1,color=color.white)
scene.forward=vector(-0.3,-0.05,-0.8)
scene.center=vector(0,0,0)
############# ei muutoksia yll #####################################################

# trmvt pallot ja niiden alkuarvot satunnaislukugeneraattorilla arvottuna
balls=[]
ballRadius=0.3
ballMass=1.5
ballNmb=10
v0=8
#Luodaan yksi pallo, joka jtt jljen 
intSide=(int)(3*side/4)
position=vector (randint(-intSide,intSide),randint(-intSide,intSide),randint(-intSide,intSide))
initVel=vector (randint(-v0,v0)/2.,randint(-v0,v0)/2.,randint(-v0,v0)/2.)
balls.append(sphere(pos=position,color = color.red, radius = ballRadius,make_trail=True, retain=300))
balls[0].velocity = initVel 
balls[0].mass=ballMass
# loput pallot harmaita
for i in range(1,ballNmb):
  initVel=vector (randint(-v0,v0)/2.,randint(-v0,v0)/2.,randint(-v0,v0)/2.)
  position=vector (randint(-intSide,intSide),randint(-intSide,intSide),randint(-intSide,intSide))
  clr=random()  # vri RGB(random,random,random)
  balls.append(sphere (pos=position,color = vector(clr,clr,clr), radius = ballRadius))
  balls[i].velocity = initVel 
  balls[i].mass=ballMass
  
e=1.0 # sysyskerroin, kaasumolekyyleill tysin kimmoinen trmys

############# Liikkeen ja trmysten ksittelyn funktiot #####################################

# Taulukossa ballColliders[N][N] silytetn tieto, mitk pallo-pallo parit ovat keskenn trmmss
# riitt taulukon ylkolmio
ballColliders=[[False for j in range(ballNmb)] for i in range(ballNmb)]
# Taulukossa planeColliders[N][6] silytetn tieto, mitk pallo-taso parit ovat  trmmss
planeColliders=[[False for j in range(planeNmb)] for i in range(ballNmb)]

# Ohjelmoi alla olevat funktiot (muista global mre ei-paikallisille muuttujille)
# Vapaa lento
def applyFlying():
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa 

# Tormystilanteiden tarkistus
def checkForCollision():
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa 

 # trmyksen pallojen kesken       
def onBallCollision(ball1, ball2):
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa 

# trmyksen pallojen ja seinien kesken
def onPlaneCollision(ball,planesIndex):
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa 


######## Simulaation pluuppi #################################################
dt = 0.01
t=0.0

while (1):
  rate(100)

  applyFlying()
 
  checkForCollision()
  # Pallojen vlisten trmysten ksittely
  
  # Pallojen ja tasojen vlisten trmysten ksittely
  
  t = t + dt
