# -*- coding: cp1252 -*-
##################################################################################
#
# Stokastinen simulaatio: Kitkaton trmys, (dokumentti ss 34 - 41)
# osittain kimmoisan pallomaisen kappaleen trmys vinoille tasoille painovoiman
# vaikutuksen alaisuudessa
# 
# Ohjelmoi funktioiden
#   applyFlying()
#   checkForCollision()
#   onCollision()
# toiminta
#
##################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

############# ei muutoksia alla #####################################################
scene.width = 800 
scene.height = 600 

# seinien koko ja paksuus
side = 5.0
thick = 0.1 # seinn paksuus ohut, jolloin sit ei huomioida en trmysten ksittelyss
s2 = 2*side

# Graafinen kuutio, jonka keskus origossa
# Laatikko luodaan koordinaattiakseleiden suuntaisesti, mutta sen asentoa
# knnetn simulaatiossa 3-ulotteisesti

# oikea sein
wallR = box (pos=vector( side,0,0),axis=vector(-1,0,0), width=s2,length=thick,height=s2,
             opacity=0.3, color = color.red) 
# vasen sein
wallL = box (pos=vector(-side, 0, 0), axis=vector(1,0,0),width=s2,length=thick,height=s2,
             opacity=0.3,  color = color.red)
# pohja
wallB = box (pos=vector(0, -side, 0),up=vector(0,1,0), width=s2,length=s2,height=thick,
             opacity=0.3, color = color.red)
# kansi
wallT = box (pos=vector(0,  side, 0), up=vector(0,-1,0),width=s2,length=s2,height=thick,
             opacity=0.3, color = color.red)
# takasein
wallBK = box(pos=vector(0, 0, -side),up=vector(0,0,1), width=s2,length=s2,height=thick,
             opacity=0.3,color = color.red)
# etusein, joka asetetaan lopuksi nkymttmksi
wallF = box(pos=vector(0, 0, side),up=vector(0,0,-1), width=s2,length=s2,height=thick,
            opacity=0.0, color=vector(0.7,0.7,0.7))

# kiertokulma, kiertoakseli ja laatikon kallistus
rotAngle=0.3
rotAxis=vector(1,1,1)
wallB.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallL.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallT.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallR.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallBK.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallF.rotate(angle=rotAngle,axis=rotAxis,origin=vector(0,0,0))
wallF.visible=False

# trmyksiss matemaattisesti ksiteltvien tasojen [n,d] konstruointi ja tallennus listaan planes[]
# Huom! tasot tulostetaan komentotulkkiin. Kaikki d-arvot negatiivisia,
# koska normaalit osoittavat kaikki origoa kohti
planes=[]


# pohjasein
nB=vector(0,1,0)
nB=rotate(nB,rotAngle,rotAxis)
dB=dot(wallB.pos,nB)
planes.append([nB,dB])

# vasen sein
nL=vector(1,0,0)
nL=rotate(nL,rotAngle,rotAxis)
dL=dot(wallL.pos,nL)
planes.append([nL,dL])

# kansi 
nT=vector(0,-1,0)
nT=rotate(nT,rotAngle,rotAxis)
dT=dot(wallT.pos,nT)
planes.append([nT,dT])

# oikea sein 
nR=vector(-1,0,0)
nR=rotate(nR,rotAngle,rotAxis)
dR=dot(wallR.pos,nR)
planes.append([nR,dR])

# takasein 
nBK=vector(0,0,1)
nBK=rotate(nBK,rotAngle,rotAxis)
dBK=dot(wallBK.pos,nBK)
planes.append([nBK,dBK])

# etusein 
nF=vector(0,0,-1)
nF=rotate(nF,rotAngle,rotAxis)
dF=dot(wallF.pos,nF)
planes.append([nF,dF])

planeNmb=len(planes)

# tasojen tulostus komentotulkkiin
for i in range(planeNmb):
  print("n=",planes[i][0],", d=",planes[i][1])

#Pohjatason ja scenen asetukset
cornerDown=rotate(vector(-side,-side,side),rotAngle,rotAxis)
box(pos=cornerDown,up=vector(0,1,0),width=s2,length=2*s2,height=0.1,color=color.white)
scene.forward=vector(-0.3,-0.05,-0.8)
scene.center=vector(0,0,0)
############# ei muutoksia yll #####################################################


# trmv pallo ja sen alkuarvot, Nit voi muuttaakin
initVel=25*norm(vector (1, 4, -3))
ball = sphere (pos=vector(0,0,0),color = color.green, radius = 0.4,make_trail=True, retain=5000)
ball.velocity = initVel 
ball.mass=0.75
e=0.8 # sysyskerroin
g=vector(0,-9.81,0)

############# Liikkeen ja trmysten ksittelyn funktiot #####################################

# listassa colliders[6] silytetn tieto, mink tasojen kanssa pallo on trmmss 
colliders=[False for j in range(6)]

# Ohjelmoi alla olevat funktiot (muista global mre ei-paikallisille muuttujille)
def applyFlying():
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa
 


def checkForCollision():
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa
 

def onCollision(n):
  # body
  i=0 # vain jotta ohjelma toimii alkutilanteessa
 




######## Simulaation pluuppi #################################################
dt = 0.001
t=0.0

while (1):
  rate(1000)

  applyFlying()
 
  checkForCollision()
  # Ohjelmoi trmmysten ksittelijfunktion kutsu
  
      
  t = t + dt
