# -*- coding: cp1252 -*-
#########################################################################
#  Jykn kappaleen dynamiikan simulaatio: (dokumentti ss 28 - 33)
#   Simuloi heilurin liike, kun massakappale on sidottu massaan nhden ohuella
#   (massattomalla ja kitkattomalla) langalla kiinnityspisteeseen. 
#   Lisarvoa simulaatioon tuovat havainnollistavat tulostukset ikkunassa sek,
#   jos heilurivarren pituutta, heilahdusliikkeen alkuarvoja voidaan st liukukoskettimilla
#   
#   Ilmanvastus tulee huomioida heilahdusliikkeen vaimenemisena (varsi voidaan jtt pois
#   ksittelyst
#   Coriolis efektin lisminen simulaatioon on extraa, jolloin vasta hyvin pitkvartisella
#   heilurilla ilmi on havaittavissa ns. Foucaultin heilurina
#   kts. http://en.wikipedia.org/wiki/Foucault_pendulum 
##########################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

# Oletusgrafiikkaikkunan koko (default window)
scene.width = 800 #ikkunan leveys nytll
scene.height = 600 #ikkunan korkeus nytll
scene.title='Reaalinen 3D heiluri'

#Koordinaatisto ja pohjaympyr ikkunaan
arrow(pos=vector(0,0,0), length=15,axis=vector(1,0,0), shaftwidth=0.3,color=color.blue)
arrow(pos=vector(0,0,0), length=15,axis=vector(0,1,0), shaftwidth=0.3,color=color.red)
arrow(pos=vector(0,0,0), length=15,axis=vector(0,0,1), shaftwidth=0.3,color=color.green)
scene.forward=vector(-0.1,-0.1,-0.5)


# Ohjelmoi puuttuvat tai virheelliset alkuasetukset
centerPoint=vector(0,0,0)
fiiMag=pi/4 #kulma fii
thetaMag=-pi/4 #kulma theta
l=25 # m varsi
mass=5 #kg massa
inertia=mass*l**2 # massapisteen hitausmomentti

# heilurin alkupaikka P ja kiertoympyriden suuntaiset alkunopeuden suuruudet
P=vector(0,-l,0)# Muuta
vfiiInit=12.5
vthetaInit=-14.0

# Kuvataan heiluri ja muut havainnollisuuden apukuvat
r=ring(pos=vector(0,-l,0),axis=vector(0,1,0),radius=l, thickness=0.1)
curve(pos=[centerPoint,r.pos],color=color.red)
ball=sphere(pos=P,color=color.magenta,radius=0.05, make_trail=True)
wire=curve(pos=[centerPoint,ball.pos],color=color.white)


#kiertokulmien kulmanopeuksien ja -kiihtyvyyksien yksikkvektorit
##nfii=?
##ntheta=?)

# Kulmanopeusvektori w=v/r (skalaareina)
##wfii=?
##wtheta=?
##w=?

# Kiertoympyriden suuntaiset alkunopeudet ja alkunopeus v
##vfii=?
##vtheta=?)
##v=?

# Kulmanopeuteen vaikuttavat voimat, painovoima ja ilmanvastus
# ilmanvastusvakio b=1/2*C*rho*A 
b=0.25*1.29*pi*ball.radius**2
##Fv=? #ilmanvastus 
##Fg=? #painovoima
##F=F? # kokonaisvoima

t=0
dt=0.001

while 1:

    rate(1000)
    # Ohjelmoi algoritmi ss. 30-31
    
    
    t +=dt
