﻿# -*- coding: cp1252 -*-
########################### Tiangong - 1 ############################
# Stokastinen simulaatio kiertoliikkeestä, (Dokumentti ss 26-27)
# Satelliitin Tiangong-1 maahansyöksy.
# Sateliitti kohtaa mýös ilmakehän yläosissa yli 50 km korkeudessa väliaibneen vastusta, 
# jonka aiheuttama ilmiö on simuloitava. Simulointi edellyttää ilmanvastuksen mallintamista.
# Tässä käytetään Newtonin vastuslakia F_v = 1/2 C A ρ v^2, minkä paikkansapitävyydestä ei ole
# varmuutta, mutta kertoimia muuttamalla saadan reaaliselta näyttävää liikettä. 
# Ilmantiheydelle on muodostettava matemaattisella ohjelmalla korkeudesta riippuva regressiofunktio, 
# joka on välillä 0<=h<=200 km eksponentti- ja polynomifunktion yhdistelmä  muotoa e^p(h) (kts. dokumentti).
# Korkeuksilla 200 km <= h <= 700 km käytetään lineaarista interpolointia taulukkoarvojen välillä.
# Vastuslain kertoimien arvot voidaan kokeilemalla arvioida sellaisiksi, että korkeuden muutos ajan
# suhteen tapahtuu riittävän reaalisesti.
#
# Tarkoituksena on selvittää, miten satelliitin nopeus muuttuu korkeuden alentuessa toisaalta
# ilmankehän vastusvoiman ja toisaalta gravitaatiovoiman muuttuessa. Nopeuden muutos kuvataan erillisella graafilla.
# Satelliitin alkukorkeus annetaan koodissa ja lasketaan sen mukainen ratanopeuden alkuarvo.
# Paremman tarkkuuden saamiseksi simulaatiossa approksimoidaan nopeuden ja paikan muutoksia
# aika-askeleella dt = 1s Runge-Kutta-Nyström -menetelmällä.
#################################################################################


from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

import numpy as np
from math import * 

########### Ei muutoksia alla #######################################################################

scene.width = 600 
scene.height = 600 

# Alla netistä otettu hyödyllinen funktio make_time_string(t), joka ilmoittaa parametreina annetun
# ajan t sopivina aikayksikkönä
def make_time_string(t):
    "Accept a number of seconds, return a relative string."
    if t < 60: return "%02i seconds"%t
    mins,secs = divmod(t, 60)
    if mins < 60: return "%02i minutes %02i seconds"%(mins,secs)
    hours, mins = divmod(mins,60)
    if hours < 24: return "%02i hours %02i minutes"%(hours,mins)
    days,hours = divmod(hours,24)
    return "%02i days %02i hours"%(days,hours)


#Globaalit vakiot 
mE = 5.9722e+24 # maan massa
mo = 8506 # Wiki: Tiangong-1:n massa, 12 m pitkä, halkaisija 3.3 m , massa 8506 kg 
do=3.3 #  poikkipinta-alan halkaisija m
G = 6.67408e-11 # Gravitational constant N m^2/kg^2
const=G*mE
rE = 6378140 # Maapallon säde m
A=pi*do**2/4 # satelliitin poikkipinta-ala m^2

########### Ei muutoksia yllä #######################################################################


######### Ohjelmoi säädettävät alkuarvot ############################################

C=0.5e-3 # ilmanvastuksen muotokerroin (dimensioton)
dragConst=0.5*C*A # käytetty vakio kaavassa drag=0.5*C*A*rho(altitude)*v**2 =
                     # dragConst*rho(altitude)*v**2, tätä tulisi muuttaa jotta vastaavuus
                     # todellisten arvojen kanssa saavutetaan
initAltitude=80000 # Satelliitin alkukorkeus maan pinnasta
finalAltitude=20000 # satelliitin loppukorkeus maan pinnasta
###############################################################################

############## Ohjelmoi oikeat alkuarvot #################################
initSpeed=0 # alkunopeus  
altitude=initAltitude  # Satelliitin alkukorkeus man pinnasta
r=vector(altitude,0,0) # Satelliitin alkuasema x-akselilla (kiertää xy-tasossa) 
v = vector(0,0,0) # Satelliitin alkunopeus kohti -z -akselia
###########################################################################

dt = 1  # aika-askel,          
t=0 

########## Ohjelmoi apufunktiot ja Runge-Kutta-Nyströn -menetelmä #######################

# Regressiolla sovitettu ilmantiheysfunktio
# Funktio laskee tiheyden välillä [0,200[ km sovitetulla eksponenttifunktiolla
# Välillä [200,700] km käytetään lineaarisia interpolointifunktioita data-arvojen välillä
# Paloittain määritelty funktio muodostetaan numpy.arrayn ja np.piecewise -funktion avulla
def density(altitude): 
    return 1.29 # = ilmantiheys maan pinnalla


# Gravitaatiovoima riippuu vain kappaleen asemasta maan keskipisteeseen nähden
def Fgrav(position):
  global const,mo
  return vector(0,0,0)

# Ilmakehän vastusvoima, termosfäärissä käytetty erikoiskertoimia
# Fdrag=-0.5e-4*C*A*rho(altitude)* mag(v)*v ( mag(v)*v = mag2(v)*norm(v) )
def Fdrag(velocity,altitude): 
  global dragConst
  return vector(0,0,0)

######### Ohjelmoi Runge-Kutta-Nyström -menetelmä ################################
# 
# Funktio F(r,v) palauttaa objektin kiihtyvyyden, kun argumenttina annetaan satelliitin paikka r ja nopeus v
# Funktio laskee gravitaatiovoiman ja väliaineen vastuksen. Globaalit muuttujat mo=objektin massa
# rE mapallon säde

def F(r,v):
    global rE, mo
    
    return vector(0,0,0)

# Funktio evaluate() returns the differential changes dv and dr of velocity v and position r using Runge-Kutta-Nyström method
def evaluate(dt,r,v):
    dr=r*dt # virheellinen asetus
    dv=v*dt # virheellinen asetus
    return [dv,dr]

######### Runge-Kutta-Nyström -menetelmä ################################



########### Ei muutoksia alla #######################################################################

# satelliitin visualisointi ja alustus
tiangong=sphere(pos=vector(initAltitude,0,0),radius=1500,color=color.red,make_trail=True,retain=50000)
tiangong.velocity=vector(0,0,-initSpeed)
# aloituskierros näytölle
ring(pos=vector(0,0,0),color=color.green,radius=initAltitude,axis=vector(0,1,0),thickness=400)
# scene
scene.range = 1.3*initAltitude
scene.center=vector(0,0,0)
scene.forward=vector(0,-1,0)

######## Nopeusgraafi-ikkuna ###########
fgcolor=color.black; bgcolor=color.white
fgcolor=color.white; bgcolor=color.black

velocity_graph = graph(width=350, height=250, 
             title='Satelliitin nopeus', xtitle='Nopeus(km/s)', ytitle='Korkeus (km)', 
             xmax=initSpeed/1000.+0.03, xmin=initSpeed/1000-0.03, ymax=initAltitude/1e3, ymin=finalAltitude/1e3, 
             foreground=fgcolor, background=bgcolor)
velocity_curve = gcurve(color=color.red)

# Luodaan tekstikehys ja sen päivitysfunktio
textLabel = label(pos=vector(0,1.3*initAltitude,0))
def updTextLabel(textLabel):
    text="Aika: " + make_time_string(t)
    text+= "\nNopeus: %.2f m/s" %mag(v)
    text += "\nKorkeus : %.1f m" %altitude
    textLabel.text=text

########### Ei muutoksia yllä #######################################################################



######## Ohjelmoi simulaatioluuppi ##################

while (1):
  rate(5000)
  if (altitude>finalAltitude) :
    ## Runge-Kutta-Nyström 

    
    
    # Nopeuden grafiikkaikkunaan tulostus
    velocity_curve.plot(mag(v)/1000,altitude/1000)

    # Itse tiangongin paikanmuutos kuvataan grafiikassa pelkästään kiertokulman ja korkeuden avulla
    # Toisin sanoen maapallo kutistetaan pisteeksi

    updTextLabel(textLabel)
    t=t+dt



