# -*- coding: cp1252 -*-
#########################################################################################
#
# Stokastinen simulaatio kiertoliikkeest (Dokumentti ss 24-25)
# Maa-kuu-systeemi (aurinko ei mukana, jolloin maa-kuu-systeemi pysyy paikoillaan
# Ohjelmoi gravitaatiovoimaan perustuva maa-kuu-simulaatio, miss kuu kiert maata
# vastapivn pohjoisnavan puolelta katsoen. Maa pyrii akselinsa ympri vastapivn pohjoisnavalta
# katsoen
# Alkuarvot  
# Mrit soveltuvat maan ja kuun alkupaikat ja alkunopeudet siten, ett
# - Maa ja kuu kiertvt yhteist kiinte massakeskipistett
# - Maa ja kuu sijaitsevat aina massakeskipisteen vastakkaisilla puolilla
#
# Maan ja kuun nopeuksille on laskettava jrkevt alkuarvot, jotta
# massakeskipiste pysyy paikoillaan ja kuun kiertoaika noudattaa
# oikeaa arvoa T=27.322 vrk

# Reaalisen fysiikan toteutuminen todennetaan pivittmll tekstikehyksess
# kuun ratanopeutta (vauhti), etisyytt maasta sek kuluvaa aikaa
#
##########################################################################################

from __future__ import division # (3/2=1.5 ei 1)
# interaktiivinen grafiikka
from vpython import *

######### ei muutoksia alla #####################################################################
# grafiikkaikkunan mritys
scene.range = 0.4e9 #koordinaatiston vaihteluvälit ikkunassa
scene.width =1200 #ikkunan leveys nytll
scene.height = 800 #ikkunan korkeus nytll
scene.forward=vector(0,-0.2,-1)

# Alla netist otettu hydyllinen funktio make_time_string(t), joka ilmoittaa parametreina annetun
# ajan t sopivina aikayksikkn
def make_time_string(t):
    "Accept a number of seconds, return a relative string."
    if t < 60: return "%02i seconds"%t
    mins,secs = divmod(t, 60)
    if mins < 60: return "%02i minutes %02i seconds"%(mins,secs)
    hours, mins = divmod(mins,60)
    if hours < 24: return "%02i hours %02i minutes"%(hours,mins)
    days,hours = divmod(hours,24)
    return "%02i days %02i hours"%(days,hours)


# Alkuarvoja muuttujille Wikipediasta
rEarth = 6.38e6  # (m) maan sde
earthTilt=radians(23.4) # napa-akselin kallistus maan ratatasoon nhden
TEarth=23*3600+56*60+4.1# maan vuorokausi  = 23 h 56 min 4,1 s

scene.center=vector(0,0,0)
rMoon = 1.74e6   # (m) kuun sde
perigee = 3.63295e8 # (m) kuun lyhin etisyys rataellipsin polttopisteesta
apogee=4.05503e8  # (m) kuun pisin etisyys rataellipsin polttopisteesta
eccentricity=0.0549 # eksentrisyys = litistyneisyyden mitta
inc=radians(5.1454) # 5.1454 deg kuun radan inklinaatiokulma xz-tason suhteen

centerOfMoonOrbit=vector(0,0,0) # massakeskipiste asetetaan origoon

# Apusuureita
# Yleinen gravitaatiovakio ja massat
G=6.67384e-11 # m^3/(kg s^2)
Emass=5.97219e24 # kg
Mmass=7.3477e22  # kg
const=G*Emass*Mmass

a=Emass/(Mmass+Emass)*apogee           # ison akselin puolikas
f=eccentricity*a           # polttopisteen etisyys maan ja kuun massakeskipisteest 
eclipticPlane=ring(pos=vector(0,0,0),axis=vector(0,1,0), radius=a,thickness=0.5e6,color=color.yellow) # maan ratataso aurinkoon
earthEquatorialPlane=ring(pos=vector(0,0,0),axis=vector(0,1,0), radius=3*rEarth*1.1,thickness=1e6,color=color.magenta) # maan ekvaattoritaso

######### ei muutoksia yll #####################################################################

# 1. Ohjelmoi maan ja kuun oikeat alkupaikat ja kaikki tarvittavat kallistukset

earthInitialPos=centerOfMoonOrbit
moonInitialPos= vector(a,0,0)

# visualisoinnin vuoksi kuvataan maa kolme kertaa todellista suurempana, mutta lpinkyvn,
# jotta maan kp:n kiertoliikkeen jlki on havaittavissa
earth=sphere(pos=earthInitialPos,radius=rEarth*3,texture=textures.earth,opacity=0.6,make_trail=True) # radius = 3*sade visualisoinnin vuoksi
axisE=arrow( pos=earth.pos,axis=10*earth.radius*vector(0,1,0),shaftwidth =earth.radius*0.1,color=color.magenta) #napa-akseli

moon=sphere(pos=moonInitialPos,radius=rMoon,color=color.white,make_trail=True)


# 2. Ohjelmoi sopivat alkunopeudet ja -liikemrt maalle ja kuulle 
# jotta kuun kierrosaika tulee oikeaksi
moon.velocity=vector(0,0,0)
earth.velocity=vector(0,0,0) 
F=vector(0,0,0)
earth.p=vector(0,0,0)
moon.p=vector(0,0,0)

# Luodaan tekstikehys ja sen pivitysfunktio
textLabel = label(pos=earth.pos +vector(0, 15*earth.radius,0))
def updTextLabel(textLabel):
    text="Aika: " + make_time_string(t)
    text+= "\nNopeus: %.0f m/s" %mag(moon.velocity)
    text += "\nEtaisyys maasta: %.0f m" %mag(moon.pos-earth.pos)
    textLabel.text=text
                        

##################################################################################
# simulaatioluuppi
##################################################################################

t=0
dt=15  # sekunttia
dangle=2*pi/TEarth*dt #radiaania


while (1) :
    rate(2000)
    
    # 3. Ohjelmoi gravitaatiovoimaan perustuvat ja impulssiperiaatteella
    # maan ja kuun kiertoliikkeet yhteisen massakeskipisteen ympri             

    
    # maan pyriminen akselinsa ympri (TEarth)
    
    # tekstikehyksen pivitys 
    updTextLabel(textLabel)
    t+=dt

